\ ICFP 2003 content entry                              28jun03py

\ Race simulation and shortest path calculation

\ Fixed Point math                                     28jun03py

include fileop.fb

Module racer-mod

: mul ( x y -- m )  m* 16 d>> drop ;
: div ( x y -- m )  0 rot 16 d>> rot sm/rem nip ;

: x. ( x -- )
    1525878907 m* <# tuck dabs # # # # # # # # # # # # # #
    '. hold #S rot sign #> 10 - type space ;

102944 Constant pi/2
205887 Constant pi
411775 Constant 2pi

: sin ( x -- )
    dup 0< IF  negate recurse negate EXIT  THEN
    dup pi/2 > If  pi swap - THEN
    dup dup mul >r ( x )
    dup r@ mul ( x x3 )
    dup r@ mul ( x x3 x5 )
    dup r> mul ( x x3 x5 x7 )
    5040 / >r 120 / >r 6 / - r> + r> - ;
: cos ( x )
    pi/2 + dup pi > IF  2pi -  THEN  sin ;

\ extended fixed pint arithmetic

: sqrt ( x -- u )  dup >r $10000 max 0 ( u l )
    BEGIN  2dup <>  WHILE
	    2dup + $20000 div ( u l g )
	    dup dup mul r@ >= IF  rot drop swap  ( u=g l )
	    ELSE  1+ nip ( u l=g+1 )  THEN
    REPEAT  rdrop drop ;

: asin ( x0 -- x )  >r 0
    dup sin r@ - over cos div -
    dup sin r@ - over cos div -
    dup sin r> - over cos div - ;

: atan ( k -- r )  dup 0< IF  negate recurse negate EXIT  THEN
    dup $10000 > IF  $10000 swap div recurse pi/2 swap - EXIT  THEN
    dup dup mul $10000 + sqrt div asin ;

: atan2 ( y x -- r )
    dup 0= IF
	over 0> IF  2drop pi/2  EXIT  THEN
	over 0< IF  2drop pi/2 negate  EXIT  THEN
	2drop 0  EXIT  THEN
    over 0= IF  dup 0> IF  2drop 0  ELSE  2drop pi  THEN  EXIT  THEN
    0 >r
    dup 0< IF  negate swap negate swap  rdrop 1 >r  THEN
    over 0< IF  swap negate swap r> 2 or >r  THEN
    2dup < IF  div atan  ELSE  swap div atan pi/2 swap -  THEN
    r@ 1 and  IF  pi -  THEN
    r> 2 and  IF  negate  THEN ;

: anglediff ( u v -- ) - pi + 2pi mod pi - ;

\ Car simulation modell                                28jun03py

Variable xold
Variable yold
Variable x
Variable y
Variable v
Variable d
Variable t

24 Constant A#
36 Constant B#
58982 Constant 0#9
22 Constant A#9
32 Constant B#9

64 Constant T#
20000 Constant L#
4 Constant F0#
12 Constant F1#
24 Constant F2#

Patch .xy     ' noop IS .xy
Patch init-xy ' noop IS init-xy

Variable a:
Variable b:
Variable l:
Variable r:
Variable x:
Variable steps 1 steps !
Variable step#
Variable steps#
Variable crash
Variable dist
Variable afrac
Variable lfrac

0 Value fd
0 Value fd2
0 Value w#
0 Value h#
0 Value x0
0 Value y0
0 Value trace
0 Value track
0 Value costs
0 Value buf1
0 Value buf2
0 Value buf3

\ simple movements

: v' ( v -- v' ) >r r@ r@ mul F2# mul r@ F1# mul + F0# + r> swap - ;
: d' ( -- delta-d ) T# v @ dup mul L# + div ;
: >d ( delta-d -- ) d @ + pi + 2pi mod pi - d ! ;
: >xy ( -- )
    v @ t @ cos mul x +!
    v @ t @ sin mul y +! .xy ;

: a A# v +! ;
: b B# negate v +! ;

: >track ( x y -- addr ) w# * + track + ;

: step-trace ( -- )  1 step# +!
    t @ d @ anglediff >r
    r@ abs d' < v @ 0= or IF  d @ t !  THEN
    v @ v' v !
    t @ d @ <>
    l: @ r: @ or b: @ and
    or
    x: @ and \ skidding
    IF
	a: @ 0= IF  B#9 negate v +! THEN
	v @ 0<  IF  v off d @ t ! rdrop EXIT  THEN
	a: @    IF
	    v @ t @ cos mul A#9 d @ cos mul +
	    v @ t @ sin mul A#9 d @ sin mul +
	    over dup mul over dup mul + sqrt v !
	    swap atan2 t !
	    t @ d @ anglediff r@ xor 0< r@ abs pi/2 < and
	    IF  d @ t !  THEN
	THEN
	[ T# 2* L# div ] Literal rdrop true >r
    ELSE
	a: @ IF a THEN b: @ IF b THEN v @ 0 max v !
	d' rdrop false >r
    THEN  ( turn )
    b: @ x: @ 0= and 0= and \ no turning while break without skidding
    l: @ IF  negate  THEN
    l: @ r: @ or and >d
    r> 0= IF  d @ t !  THEN  >xy
    x @ $10 >> y @ $10 >> w# * + cells costs + @
    dup 0= IF  step# @ steps# ! d @ abs pi/2 >= crash !  THEN
    dup -1 = crash @ 0= and
    IF  step# @ steps# ! crash on  THEN
    crash @ 0= IF  dup dist !  THEN  drop ;

: steps-trace ( -- )
    steps @ 1 max 0 ?DO  step-trace  LOOP
    a: off b: off l: off r: off steps off ;

: clear-state ( -- )
    x0 $10 << dup x ! $10 >> xold ! y0 $10 << dup y ! $10 >> yold ! init-xy
    v off d off t off step# off steps# off crash off afrac off lfrac off ;

: run-trace ( addr u -- ) clear-state
    bounds ?DO
	I c@ digit? IF  steps @ &10 * + steps !  THEN
        I c@ 'a = IF a: on b: off THEN
        I c@ 'b = IF b: on a: off THEN
        I c@ 'l = IF l: on r: off THEN
	I c@ 'r = IF r: on l: off THEN
	I c@ 'x = IF x: on THEN
	I c@ '. = IF steps-trace THEN
    LOOP ;

\ Track to icon                                        28jun03py

Create .road   $00 c, $00 c, $00 c,
Create .start  $FF c, $80 c, $00 c,
Create .goal   $FF c, $FF c, $FF c,
Create .red    $80 c, $00 c, $00 c,
Create .green  $00 c, $80 c, $00 c,
Create .blue   $00 c, $00 c, $80 c,
Create .white  $80 c, $80 c, $80 c,
Create .other  $40 c, $40 c, $40 c,

: track2icon ( addr u addr u -- )
    r/w create-file throw to fd2
    r/w open-file throw   to fd
    s" P6" fd2 write-line throw
    s" # Creator: track2icon" fd2 write-line throw
    pad dup 10 fd read-line throw drop s>number drop to w#
    pad dup 10 fd read-line throw drop s>number drop to h#
    w# 0 h# 0 <# #S bl hold 2drop #S #> fd2 write-line throw
    s" 255" fd2 write-line throw
    h# 0 ?DO
        pad dup w# 1+ fd read-line throw drop
        bounds ?DO
            I c@ CASE
                '. OF  .road  ENDOF
                '* OF  .start ENDOF
                '! OF  .goal  ENDOF
                'r OF  .red   ENDOF
                'g OF  .green ENDOF
                'b OF  .blue  ENDOF
                'w OF  .white ENDOF
                .other swap  ENDCASE
            3 fd2 write-file throw
        LOOP
    LOOP
    s" P4" fd2 write-line throw
    s" # Creator: track2icon" fd2 write-line throw
    w# 0 h# 0 <# #S bl hold 2drop #S #> fd2 write-line throw
    pad w# h# 8 */ 2dup $FF fill fd2 write-file throw
    fd close-file throw
    fd2 close-file throw ;

\ read track                                           28jun03py

also memory

Variable track-name

: read-track ( addr u -- )
    2dup track-name $! r/w open-file throw   to fd
    pad dup 10 fd read-line throw drop s>number drop to w#
    pad dup 10 fd read-line throw drop s>number drop to h#
    track IF  track DisposPtr  THEN  w# h# * NewPtr to track
    costs IF  costs DisposPtr  THEN  w# h# * cells NewPtr to costs
    buf1 IF  buf1 DisposPtr  THEN  w# h# * 4/ cells NewPtr to buf1
    buf2 IF  buf2 DisposPtr  THEN  w# h# * 4/ cells NewPtr to buf2
    buf3 IF  buf3 DisposPtr  THEN  w# h# * 4/ cells NewPtr to buf3
    h# 0 ?DO
        pad dup w# 1+ fd read-line throw drop
        bounds ?DO
            I c@ CASE
                '. OF  0  ENDOF
                '* OF  w# I' I - - J to y0 to x0 0  ENDOF
                '! OF  2  ENDOF
                1 swap  ENDCASE
            w# I' I - - J >track c!
        LOOP
    LOOP
    fd close-file throw clear-state shift>all ;

: run-file ( addr u -- )
    r/w open-file throw to fd
    trace IF  trace DisposPtr  THEN
    fd file-size throw drop NewPtr to trace
    0. fd reposition-file throw
    trace dup fd file-size throw drop fd read-file throw
    fd close-file throw run-trace ;

previous

\ racer drawing module

script? 0 to script?
include racer.m
to script?

racer ptr racer-win

also minos

: (.xy) ( -- )
    crash @ IF
	racer-win graphics with $FF $00 $00 rgb> drawcolor endwith
    THEN
    x @ $10 >> xold @ -
    y @ $10 >> yold @ -
    2dup d0= IF  2drop
    ELSE  racer-win graphics with path negate to stroke endwith  THEN
\    cr step# @ 5 .r ."  :" x @ 10 .r y @ 10 .r v @ 10 .r d @ 10 .r t @ 10 .r
\   cr x @ x. y @ x.
    x @ $10 >> xold ! y @ $10 >> yold !
    xold @ yold @ >track c@
    2 = d @ abs pi/2 < and IF ( ." reached goal" cr ) THEN ;
' (.xy) IS .xy

: (init)  racer-win self IF
    x @ $10 >> y @ $10 >> racer-win graphics home!  THEN ;
' (init) IS init-xy

previous

\ Best path discovery function

\ To see who's best, a shortest path to target algorithm is used. This
\ time, I use an euclidean path length discovery flood fill algorithm,
\ where diagonal points are sqrt(2) points away.

\ shortest path discovery

Variable buf1#
Variable buf2#
Variable buf3#
$20000 sqrt Constant sq2
Variable cur-n

: rot-buf ( -- )
    buf2# @ buf3# ! buf1# @ buf2# ! buf1# off
    buf1 buf2 buf3 to buf1 to buf3 to buf2 ;

: way, ( addr n -- )
    2dup swap ! cur-n @ swap - $10000 <=
    IF    buf2 buf2# @ cells + ! 1 buf2# +!
    ELSE  buf1 buf1# @ cells + ! 1 buf1# +!  THEN ;

: try, ( addr n -- ) over costs - cell/ track + c@
    IF  2drop  EXIT  THEN
    over @ over u> IF  way,  ELSE  2drop  THEN ;

: try-ewns ( addr n -- ) >r
    dup cell+ r@ try,
    dup cell- r@ try,
    dup w# cells + r@ try,
    w# cells - r> try, ;

: try-diag ( addr n -- ) >r
    dup cell+ w# cells + r@ try,
    dup cell- w# cells + r@ try,
    dup cell+ w# cells - r@ try,
    cell- w# cells - r> try, ;

: try-all ( addr n -- )
    2dup $10000 + try-ewns
    sq2 + try-diag ;

: exec-buf ( -- )
    buf3 buf3# @ cells bounds ?DO
	I @ dup @ try-all
    cell +LOOP $10000 cur-n +! ;

: init-calc ( -- )
    costs w# h# * cells $FF fill
    buf1# off buf2# off buf3# off cur-n off
    track 1+ w# h# * 1- bounds ?DO
	I c@ 2 =  IF
	    I track - cells costs + dup off cell- $10000 way,
	THEN
    LOOP ;

Variable start-cost

: calculate-way ( -- )  init-calc
    BEGIN  buf1# @ buf2# @ or  WHILE  rot-buf exec-buf  REPEAT
    x0 y0 w# * + cells costs + @ start-cost ! ;

\ display path length as PGM

also memory

: save-way ( addr u -- )
    r/w create-file throw to fd
    s" P5" fd write-line throw
    s" # Creator: save-way" fd write-line throw
    w# 0 h# 0 <# #S bl hold 2drop #S #> fd write-line throw
    s" 255" fd write-line throw
    w# h# * NewPtr dup
    costs w# h# * cells bounds ?DO
	I 2+ c@ over c! 1+
    cell +LOOP
    drop dup w# h# * fd write-file throw
    DisposPtr fd close-file throw ;

previous

\ Genetic algorithm

\ uses a genetic programming approach: "Genes" are segments with
\ fractional value of a/b, r/l, start and end value to be lineary
\ interpolated in between.  Mutations change these fractional values,
\ the length, and duplicate end segments. Mutations also can split up
\ segments into two. Segments also can be dropped (the smaller the
\ segment, the more likely). Mutations are stronger on the end of the
\ segment, i.e. the path "grows" towards the goal, and the root is
\ quite stable and optimal. Pathes that run off road are
\ killed. Pathes are scored by how far they get, and how fast they
\ are.

\ player for genes

$10 Value population#
0 Value population
6 Cells Constant /gene

: >turn ( -- )
    lfrac @ abs $10000 >= lfrac @ 0< IF r: ELSE l: THEN ! ;
: >acc ( -- flag )  afrac @ abs $10000 >= ;
: +-upd ( flag1 flag2 -- value )
    -$10000 and swap $10000 and or ;

: ?emit ( char flag -- ) IF emit ELSE drop THEN ;
: .move ( -- )
    'a a: @ ?emit 'b b: @ ?emit 'l l: @ ?emit 'r r: @ ?emit
    '. emit ;

Variable .move?

: frac-step ( afrac lfrac -- )
    1 steps ! lfrac +! afrac +!
    afrac @ 0> IF \ both acceleration and turn work together
	>acc a: ! >turn
    ELSE
	x: @ afrac @ abs lfrac @ abs + $80000 > and IF
	    >acc b: ! >turn $70000 afrac +!  \ start skidding
	ELSE  afrac @ abs lfrac @ abs > IF  >acc b: !  ELSE  >turn  THEN
	THEN
    THEN
    b: @ a: @ +-upd afrac +!
    r: @ l: @ +-upd lfrac +!
    .move? @ IF  .move  THEN
    steps-trace ;

: pair+ ( a l da dl -- )  8 >> rot + >r 8 >> + r> ;

: frac-steps ( da dl afrac lfrac steps -- )  lfrac off afrac off
    0 ?DO  2dup frac-step 2over pair+
	steps# @ ?LEAVE  v @ 0= ?LEAVE  LOOP  2drop 2drop ;

: run-gene ( addr u -- dist steps )
    bounds ?DO  I @+ @+ @+ @+ @ 8 >> frac-steps
	steps# @ ?LEAVE  /gene +LOOP
    dist @ step# @ steps# @ max pause ;

\ score function

\ the smaller the score, the better the gene

&15 Value step-score
&10000000 Value target-score
&1000000 Value crash-score

: score ( dist steps -- )
    over >r step-score * + r> 0<> target-score and +
    crash @ crash-score and + ;

\ Gene selection

: cut-crash ( addr n -- )
    over $@ cell /string bounds ?DO
	I 4 cells + @ 8 >> - dup 0< IF
	    dup 8 << I 4 cells + +!
	    over $@ drop I /gene + swap - 2 pick $!len
	    LEAVE
	THEN
    /gene +LOOP  2drop ;

: cleanup-gene ( addr -- )
    dup $@len cell- /gene / 0 ?DO
	dup $@ I' I 1+ - /gene * cell+ /string drop 4 cells + @ &11 >>
	0= IF  dup I' I 1+ - /gene * cell+ /gene $del  THEN
    LOOP drop ;

: cleanup-genes
    population population# cells bounds ?DO
	I @ cleanup-gene
    cell +LOOP ;

: .genes
    population# 0 ?DO
	population I cells + @ $@ drop @
	cr ." gene " I . ." scores " .
	population I cells + @ $@ cell /string
	bounds ?DO  cr I @ . I cell+ @ .
	    I 2 cells + @ x. I 3 cells + @ x.
	    I 4 cells + @ 8 >> .
	/gene +LOOP
    LOOP ;

: gene-sort ( gene1 gene2 -- )
    $@ drop @ >r $@ drop @ r> <= ;
: select-genes ( -- ) ['] gene-sort IS lex
    population population# sort
    population dup population# cells dup 2/ /string
    bounds ?DO dup @ $@ I @ $! cell+  cell +LOOP drop .genes ;

\ initialization and mutation

$90 Value mutvar

3 Value add-like

: mutate-pars ( addr u -- )
    0 -rot bounds ?DO
	I' I - /gene mod 0= IF  drop I 5 cells + @ 8 >> THEN
	dup random dup * 2 random IF negate THEN
	I' I - /gene 2* / ( 0= and \ ) 1+ dup * /
	I' I - /gene / &10 < and
	I +!
    cell +LOOP drop ;
: mutate-pars2 ( addr u -- )
    0 -rot bounds ?DO
	I' I - /gene mod 0= IF  drop I 5 cells + @ 8 >> THEN
	dup random dup * 2 random IF negate THEN
	I' I - /gene 4* / ( 0= and \ ) 1+ dup dup * * /
	I' I - /gene / &10 < and
	I +!
    cell +LOOP drop ;
: mutate-pars3 ( addr u -- )
    0 -rot bounds ?DO
	I' I - /gene mod 0= IF  drop I 5 cells + @ 8 >> THEN
	dup random dup * 2 random IF negate THEN
	I' I - /gene 8* / ( 0= and \ ) 1+ dup dup dup * * * /
	I' I - /gene / &10 < and
	I +!
    cell +LOOP drop ;

: -genes ( addr n -- ) >r dup $@len r> /gene * - swap $!len ;
: -gene ( addr -- ) dup $@len /gene - swap $!len ;
: short-last ( addr -- )
    BEGIN  dup $@ + 2 cells - dup @ 2/ $800 - dup rot !
	0<= WHILE  dup -gene  REPEAT  drop ;

: mutate-simple ( addr -- ) >r
    6 random CASE
	0 OF  r@ short-last  ENDOF
	1 OF  r@ $@ mutate-pars  ENDOF
	2 OF  r@ $@ mutate-pars2  ENDOF
	3 OF  r@ $@ mutate-pars3  ENDOF
    ENDCASE rdrop ;

: mutate-gene ( addr -- ) >r
    5 random CASE
	0 OF  r@ short-last  ENDOF
	1 OF  r@ $@ mutate-pars  ENDOF
	2 OF  r@ $@ mutate-pars2  ENDOF
	3 OF  r@ $@ mutate-pars3  ENDOF
	4 OF  r@ dup $@len cell- /gene / 1- 0 max 4 min random -genes
	    r@ mutate-simple  ENDOF
    ENDCASE rdrop ;

: mutate-genes ( -- )
    population population# cells dup 2/ /string bounds ?DO
	I @ mutate-gene
    cell +LOOP ;

: mutate-dupes ( -- )
    1 population# 1- DO
	population I cells + dup @ $@ rot cell- @ $@ str=
	IF  population I cells + @ mutate-gene  THEN
    -1 +LOOP ;

\ find best gene

Create geneX  0 , 0 , 0 , 0 , 0 , $50000 , mutvar 8 << ,
Create geneY  0 , 0 , 0 , 0 , 0 , $50000 , mutvar 8 << ,
Variable best-score
Variable finish?
5 Value per-try
5 Value per-curve
3 Value per-step
&20 Value try-steps
$10000 Value max-acc
$10000 Value max-turn
$3000 Value max-diff

: try-gene ( -- score )  init-xy
    x push y push d push t push v push xold push yold push
    steps# push step# push crash off
    geneX cell+ /gene run-gene ;

: minmax ( val max -- val' ) tuck negate max min ;
: ran+ ( max I steps -- val )  1- dup >r 2 pick >r */ r@ 2/ -
    r> r> over >r / dup random swap 2/ - + r> minmax ;

: best-gene ( -- )  best-score on
\    cr x @ x. y @ x. d @ x. t @ x. v @ x.
    per-try 0 ?DO  max-acc 2* I per-try ran+ geneX 3 cells + !
	per-curve 0 ?DO  max-turn 2* I per-curve ran+ geneX 4 cells + !
	    per-step 0 ?DO  max-diff I per-step ran+ geneX 1 cells + !
		per-step 0 ?DO  max-diff I per-step ran+ geneX 2 cells + !
		    try-gene 2dup score dup best-score @ u< IF
			best-score !  geneX geneY /gene move
			step# @ - 8 <<
			finish? @ 0= IF  &10 random 2 + try-steps */  THEN
			$1000 max geneY 5 cells + ! drop
		    ELSE  drop 2drop  THEN
		LOOP
	    LOOP
	LOOP
    LOOP ;

also memory

: run-genes ( -- )
    population# 0 ?DO
	I .
	clear-state
	population I cells + @ HLock
	population I cells + @ $@ cell /string run-gene
	population I cells + @ HUnLock
\	score population I cells + @ $@ drop !
	2drop best-gene best-score @
	population I cells + @ $@ drop !
	geneY cell+ /gene population I cells + @ $+!
	v @ 0= IF  step# @ steps# !  THEN
	steps# @ IF  population I cells + @ steps# @
	    dist @ 0<> IF 8 - THEN cut-crash  THEN
    LOOP cr ;

: init-genes ( -- )
    population# cells NewPtr to population
    population population# cells bounds ?DO
	best-gene best-score @ geneY !
	NewMP dup off I ! geneY /gene cell+ I @ $!
    cell +LOOP ;

previous

\ mutate

also minos

Variable racer-icon

: clear-racer ( -- ) racer-icon @
    racer-win graphics with  0 0 home!  icon
    x0 y0 home! $FF $FF $00 rgb> drawcolor endwith ;

also fileop

: .best-path ( -- )
    track-name dup $@ nip 1- 1 $del
    s" c" track-name $+!
    track-name $@ r/w output-file +buffer
    .move? on x: @ IF  'x emit  THEN  clear-racer clear-state
    population @ $@ 4 /string run-gene 2drop eot .move? off ;

previous

: mutations ( n -- )  .move? off  timer@ seed ! \ initialize random seed
    0 ?DO   clear-racer run-genes
	cleanup-genes select-genes mutate-genes	mutate-dupes
	stop? ?LEAVE
    LOOP  .best-path ;
: mutate-only ( n -- )  .move? off  timer@ seed ! \ initialize random seed
    0 ?DO  clear-racer ['] gene-sort IS lex
	population population# sort mutate-genes mutate-dupes run-genes
	cleanup-genes stop? ?LEAVE
    LOOP  finish? on  clear-racer run-genes .best-path finish? off ;

: init-racer ( icon -- )  dup racer-icon !  racer-win self 0=
    IF  racer new bind racer-win
	racer-win self 0 s" Racer Graphics" open-component  THEN
    racer-win graphics with  0 0 textpos w# h# steps  0 0 home!  icon
    x0 y0 home! $FF $FF $00 rgb> drawcolor endwith calculate-way ;

\ load tasks

: race1  s" 1_Simple.trk" read-track icon" 1_Simple.icn" init-racer ;
: race2  s" 2_Hairpins.trk" read-track icon" 2_Hairpins.icn" init-racer ;
: race3  s" 3_Sepang.trk" read-track icon" 3_Sepang.icn" init-racer ;
: race4  s" 4_EatYouAlive.trk" read-track icon" 4_EatYouAlive.icn" init-racer ;
: race5  s" 5_Car.trk" read-track icon" 5_Car.icn" init-racer ;
: race6  s" 6_IcfpContest.trk" read-track icon" 6_IcfpContest.icn" init-racer ;
: race7  s" 7_Gothenburg.trk" read-track icon" 7_Gothenburg.icn" init-racer ;
: race8  s" 8_ManyWays.trk" read-track icon" 8_ManyWays.icn" init-racer ;
: race9  s" 9_PhilAndSimon.trk" read-track icon" 9_PhilAndSimon.icn" init-racer ;
: raceX  s" X_Rally.trk" read-track icon" X_Rally.icn" init-racer ;
: raceEen s" Een.trk" read-track icon" Een.icn" init-racer ;

previous

Module;

racer-mod also