\needs float import float

Module vectors
also float
\ vector variable better have names ending with "(" for readability
\ fetches
| create fetch_operations ' c@ , ' w@ , ' @ , 0 , ' 2@ , ' f@ ,
\ stores
| create store_operations ' c! , ' w! , ' ! , 0 , ' 2! , ' f! ,
| : type-idx ( cell_size -- idx ) 2/ ; macro
| : f-op ( cell-size -- cfa ) type-idx cells fetch_operations + @ ;
| : s-op ( cell-size -- cfa ) type-idx cells store_operations + @ ;
: *)! ( *vector -- addr ) [ 3 cells ] literal - @ ;
: *)@ ( *vector -- addr ) [ 4 cells ] literal - @ ;
: )type ( *vector -- size ) [ 2 cells ] literal - @ ;
: )free ( *vector -- ) [ 4 cells ] literal - free throw ;
\ header | fetch_cfa | store_cfa | el_size | #els |
\ unnamed vector
: _vector ( n cell-size -- addr )
    2dup * [ 4 cells ] literal + allocate throw
    dup >r   over f-op swap !
    r@ cell+ over s-op swap !
    r@ [ 2 cells ] literal + ! \ cell size store
    r@ [ 3 cells ] literal + ! \ #els store
    r> [ 4 cells ] literal + ;
\ vector of pointers
: vector*  ( # -- *vector ) cell _vector ;
: )! ( value *vector index -- )
    over dup *)! >r )type * + r> execute ;


clear
previous
Module;